<?php
date_default_timezone_set('Europe/Athens');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/Exception.php';
require 'PHPMailer/PHPMailer.php';
require 'PHPMailer/SMTP.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // ==========================================
    // 1. ΡΥΘΜΙΣΕΙΣ SMTP (ΣΥΜΠΛΗΡΩΣΕ ΤΑ ΕΔΩ)
    // ==========================================
    $smtp_host = 'mail.eppap.gr';   // π.χ. smtp.gmail.com ή mail.todomainsoy.gr
    $smtp_username = 'noreply@eppap.gr'; // Το email που θα στέλνει
    $smtp_password = 'JBAXW,bDhClPFYpw';      // Ο κωδικός του email
    $smtp_port = 465;                         // Συνήθως 587 (TLS) ή 465 (SSL)
    $smtp_secure = PHPMailer::ENCRYPTION_SMTPS; // ή PHPMailer::ENCRYPTION_SMTPS για θύρα 465

    // Ρυθμίσεις Παραληπτών
    $eppap_email = "eppap@otenet.gr";
    $bcc_emails = [
        "info@digitalmall.gr",
        "smartbetopap@gmail.com"
    ];
    
    $phone_contact = "2105221364";
    $election_date = "12/01/2026";
    // ==========================================

    // Λήψη δεδομένων Φόρμας
    $fullname = htmlspecialchars($_POST['fullname']);
    $fathername = htmlspecialchars($_POST['fathername']);
    $agency_id = htmlspecialchars($_POST['agency_id']);
    $id_number = htmlspecialchars($_POST['id_number']); 
    $mobile_phone = htmlspecialchars($_POST['mobile_phone']); 
    $user_email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $date = htmlspecialchars($_POST['date']);
    $ip_address = $_SERVER['REMOTE_ADDR'];
    
    // Το όνομα του αρχείου που θα αποθηκεύει τα κλειδιά (Email_Mobile)
    $log_file = __DIR__ . '/logs/submitted_entries.txt';

    // Αν το αρχείο δεν υπάρχει, το δημιουργούμε
    if (!file_exists($log_file)) {
        touch($log_file);
    }

    // Δημιουργία του μοναδικού κλειδιού για έλεγχο
    // Μορφή: email_kinito (π.χ. test@email.com_6970000000)
    $submission_key = trim(strtolower($user_email)) . "_" . trim($mobile_phone);

    // Διαβάζουμε το αρχείο σε πίνακα, αγνοώντας κενές γραμμές
    $existing_entries = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    // Έλεγχος αν το κλειδί υπάρχει ήδη
    $already_submitted = false;
    if ($existing_entries) { // Έλεγχος αν υπάρχουν εγγραφές
        foreach ($existing_entries as $stored_entry) {
            if (trim($stored_entry) === $submission_key) {
                $already_submitted = true;
                break;
            }
        }
    }

    if ($already_submitted) {
        // Εμφάνιση μηνύματος λάθους και τερματισμός (EXIT)
        echo "
        <!DOCTYPE html>
        <html lang='el'>
        <head><meta charset='UTF-8'><meta name='viewport' content='width=device-width, initial-scale=1.0'><title>Σφάλμα</title></head>
        <body style='font-family: Helvetica, Arial, sans-serif; text-align: center; padding: 20px; background-color: #F4F7F6;'>
            <div style='background: white; padding: 40px; border-radius: 10px; max-width: 500px; margin: 0 auto; box-shadow: 0 4px 15px rgba(0,0,0,0.1); border-top: 5px solid #cc0000;'>
                <h2 style='color:#cc0000;'>Η υποβολή απέτυχε</h2>
                <p>Έχετε ήδη υποβάλει δήλωση με τα εξής στοιχεία:</p>
                <p>Email: <strong>$user_email</strong><br>
                   Κινητό: <strong>$mobile_phone</strong></p>
                <p>Δεν επιτρέπονται πολλαπλές υποβολές με τα ίδια στοιχεία επικοινωνίας.</p>
                <br>
                <a href='https://eppap.gr' style='background-color: #555; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Επιστροφή</a>
            </div>
        </body>
        </html>
        ";
        exit(); // Σταματάμε την εκτέλεση του κώδικα εδώ
    }

    // Αν δεν υπάρχει, το καταγράφουμε στο αρχείο
    file_put_contents($log_file, $submission_key . PHP_EOL, FILE_APPEND | LOCK_EX);
    
    // ============================================================
    //  NEW LOGIC: SAVE TO CSV EXCEL FILE
    // ============================================================
    
    $csv_file = __DIR__ . '/logs/submissions_registry.csv';
    $is_new_file = !file_exists($csv_file);

    // Ανοίγουμε το αρχείο για εγγραφή στο τέλος ('a' = append)
    $csv_handle = fopen($csv_file, 'a');

    if ($csv_handle !== false) {
        // Αν το αρχείο είναι καινούργιο, βάζουμε πρώτα τους τίτλους (BOM για σωστά Ελληνικά στο Excel)
        if ($is_new_file) {
            // Προσθήκη UTF-8 BOM για να ανοίγει σωστά στο Excel
            fwrite($csv_handle, "\xEF\xBB\xBF");
            fputcsv($csv_handle, [
                'Αρ. Πρακτορείου',
                'ΑΦΜ',
                'Ονοματεπώνυμο',
                'Πατρώνυμο',
                'Κινητό',
                'Email',
                'Ημερομηνία Δήλωσης',
                'IP Address'
            ]);
        }

        // Τα δεδομένα προς αποθήκευση
        $csv_data = [
            $agency_id,
            $id_number,
            $fullname,
            $fathername,
            $mobile_phone,
            $user_email,
            $date,
            $ip_address
        ];

        // Εγγραφή της γραμμής στο CSV
        fputcsv($csv_handle, $csv_data);

        // Κλείσιμο αρχείου
        fclose($csv_handle);
    }

    // ============================================================
    //  END CSV LOGIC
    // ============================================================
    
    $pdf_base64 = $_POST['declaration_pdf'];
    $pdf_filename = "Δήλωση_Εκλογές_{$fullname}_{$agency_id}.pdf";
    
    $timestamp = date("Ymd-His");
    $pdf_save_filename = "Δήλωση_Εκλογές_{$fullname}_{$agency_id}_{$timestamp}.pdf";
    $pdf_save_directory = __DIR__ . '/declarations/';
    
    // -------------------------------------------------------------
    // --- ΔΙΟΡΘΩΣΗ ΓΙΑ ΤΗΝ ΥΠΟΓΡΑΦΗ (Embedded Image / CID) ---
    // -------------------------------------------------------------
    $signature_raw = $_POST['signature_image']; // Τα δεδομένα Base64 από τη JS
    $has_signature = false;
    $signature_data = null;
    
    // Έλεγχος αν ήρθε όντως υπογραφή και δεν είναι κενή
    if (!empty($signature_raw) && strpos($signature_raw, 'data:image/png;base64,') === 0) {
        // Αφαιρούμε την επικεφαλίδα "data:image/png;base64," για να μείνει μόνο ο κώδικας
        $base64_str = str_replace('data:image/png;base64,', '', $signature_raw);
        $base64_str = str_replace(' ', '+', $base64_str); // Διόρθωση για κενά που μπορεί να γίνουν url encoded
        $signature_data = base64_decode($base64_str); // Μετατροπή σε binary εικόνα
        
        if ($signature_data) {
            $has_signature = true;
        }
    }
    
    // Το HTML που θα μπει στο table. Αν υπάρχει υπογραφή βάζουμε CID reference.
    // Το 'cid:my_signature' είναι σαν εσωτερικό link που θα ορίσουμε παρακάτω.
    $signature_html = $has_signature 
        ? "<img src='cid:my_signature' width='200' style='border:1px solid #ccc; padding:5px;'>" 
        : "<em>Δεν υπεγράφη</em>";

    // Δημιουργία αντικειμένου PHPMailer
    $mail = new PHPMailer(true);

    try {
        // --- Ρυθμίσεις Server (Κοινές και για τα δύο email) ---
        // $mail->SMTPDebug = SMTP::DEBUG_SERVER; // Ενεργοποίησε το αν έχεις πρόβλημα για να δεις logs
        $mail->isSMTP();
        $mail->Host       = $smtp_host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $smtp_username;
        $mail->Password   = $smtp_password;
        $mail->SMTPSecure = $smtp_secure;
        $mail->Port       = $smtp_port;
        $mail->CharSet    = 'UTF-8';

        // ==========================================
        // EMAIL 1: ΠΡΟΣ ΕΠΠΑΠ (ΥΠΗΡΕΣΙΑΚΟ)
        // ==========================================
        $mail->setFrom($smtp_username, 'Ηλεκτρονικές Δηλώσεις');
        $mail->addAddress($eppap_email);     // Παραλήπτης: ΕΠΠΑΠ
        $mail->addReplyTo($user_email, $fullname); // Αν πατήσει απάντηση η ΕΠΠΑΠ, να πάει στον χρήστη
        
        foreach ($bcc_emails as $bcc_email) {
            $mail->addBCC($bcc_email);
        }
        
        // *** ΕΔΩ ΓΙΝΕΤΑΙ Η ΜΑΓΕΙΑ ΤΗΣ ΕΠΙΣΥΝΑΨΗΣ ***
        if ($has_signature) {
            // addStringEmbeddedImage(binary_data, cid_id, filename, encoding, type)
            $mail->addStringEmbeddedImage($signature_data, 'my_signature', 'signature.png', 'base64', 'image/png');
        }
        
        // Επισύναψη PDF (Δήλωση)
        if (!empty($pdf_base64)) {
            $pdf_data = base64_decode($pdf_base64);
            $pdf_file_path = $pdf_save_directory . $pdf_save_filename;

            file_put_contents($pdf_file_path, $pdf_data);
            
            $mail->addStringAttachment($pdf_data, $pdf_filename, 'base64', 'application/pdf');
        }

        $mail->isHTML(true);
        $mail->Subject = "Δήλωση Συμμετοχής: $fullname";
        $mail->Body    = "
            <html>
            <body style='font-family: Arial, sans-serif;'>
                <h3>ΔΗΛΩΣΗ ΣΥΜΜΕΤΟΧΗΣ ΣΕ ΗΛΕΚΤΡΟΝΙΚΗ ΨΗΦΟΦΟΡΙΑ</h3>
                <p><strong>Προς:</strong> Εφορευτική Επιτροπή ΕΠΠΑΠ</p>
                <table style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>
                    <tr><td style='width: 150px; font-weight: bold;'>Ονοματεπώνυμο:</td><td>$fullname</td></tr>
                    <tr><td style='font-weight: bold;'>Πατρώνυμο:</td><td>$fathername</td></tr>
                    <tr><td style='font-weight: bold;'>Αρ. Πρακτορείου:</td><td>$agency_id</td></tr>
                    <tr><td style='font-weight: bold;'>ΑΦΜ Πρακτορείου:</td><td>$id_number</td></tr>
                    <tr><td style='font-weight: bold;'>Κινητό:</td><td>$mobile_phone</td></tr>
                    <tr><td style='font-weight: bold;'>Email:</td><td>$user_email</td></tr>
                    <tr><td style='font-weight: bold;'>Ημερομηνία:</td><td>$date</td></tr>
                    <tr><td style='font-weight: bold; vertical-align: top;'>Υπογραφή:</td><td>$signature_html</td></tr>
                </table>
                <div style='background-color: #f9f9f9; padding: 15px; border: 1px solid #ddd;'>
                    <strong>ΥΠΕΥΘΥΝΗ ΔΗΛΩΣΗ:</strong><br>
                    Με την παρούσα δηλώνω υπεύθυνα ότι:<br>
                    1. Επιθυμώ να συμμετάσχω στις εκλογές της $election_date με ηλεκτρονικό/ψηφιακό τρόπο.<br>
                    2. Τα στοιχεία που δηλώνω είναι ακριβή και αληθή.<br>
                    3. Συναινώ στην επεξεργασία των δεδομένων μου για σκοπούς ταυτοποίησης.<br>
                    4. Γνωρίζω ότι επιλέγοντας την ηλεκτρονική ψήφο, δεν έχω δικαίωμα συμμετοχής με φυσική παρουσία στην κάλπη.<br>
                    5. Η παρούσα υποβάλλεται από το προσωπικό μου email που αποτελεί μέσο ταυτοποίησης.
                </div>
                <p style='font-size: 11px; color: #666; margin-top: 30px; border-top:1px solid #eee; padding-top:10px;'>
                    Σύστημα Καταγραφής Δηλώσεων<br>
                    IP Αποστολέα: $ip_address
                </p>
            </body>
            </html>
        ";

        $mail->send(); // Αποστολή πρώτου email

        // ==========================================
        // EMAIL 2: ΠΡΟΣ ΧΡΗΣΤΗ (ΕΠΙΒΕΒΑΙΩΣΗ)
        // ==========================================
        $mail->clearAddresses(); // Καθαρισμός παραληπτών για το δεύτερο email
        // $mail->clearAttachments();
        $mail->clearBCCs();
        $mail->clearReplyTos();
        
        $mail->setFrom($smtp_username, 'Εκλογές ΕΠΠΑΠ');
        $mail->addAddress($user_email); // Παραλήπτης: Ο Χρήστης

        $mail->Subject = "Επιβεβαίωση Δήλωσης - Εκλογές ΕΠΠΑΠ";
        $mail->Body    = "
            <html>
            <body style='font-family: Arial, sans-serif;'>
                
                <div style='text-align:center; margin-bottom:20px; border-bottom: 2px solid #0056B3; padding-bottom: 10px;'>
                   <img src='https://cdn.digitalmall.gr/logos/eppap.jpg' width='120' alt='Λογότυπο ΕΠΠΑΠ'>
                   <p style='font-style:italic; color:#555;'>Καμια αποσταση αναμεσα στην ΕΠΠΑΠ και τον πράκτορα!</p>
                </div>
                
                <p>Αγαπητέ/ή <strong>$fullname</strong>,</p>
                <p>Η δήλωσή σας παραλήφθηκε επιτυχώς.</p>
                
                <div style='background-color: #eef4fa; padding: 15px; border-left: 4px solid #0056b3; margin: 20px 0;'>
                    <strong>Στοιχεία που δηλώσατε:</strong><br>
                    Κωδ. Πρακτορείου: <strong>$agency_id</strong><br>
                    Πατρώνυμο: $fathername<br>
                    ΑΦΜ Πρακτορείου: $id_number<br>
                    Κινητό: $mobile_phone<br>
                    Email: $user_email<br>
                    Ημερομηνία: $date<br><br>
                    $signature_html
                </div>
                
                <p>Δηλώσατε υπεύθυνα ότι επιθυμείτε να ψηφίσετε ηλεκτρονικά, παραιτούμενοι του δικαιώματος φυσικής παρουσίας στις εκλογές της $election_date.</p>
                
                <div style='background-color: #FFF3CD; border: 1px solid #FFEEBA; padding: 15px; font-size: 13px; margin-top: 20px; border-left: 4px solid #cc0000;'>
                    <strong>ΔΗΛΩΣΗ ΕΝΑΝΤΙΩΣΗΣ:</strong><br>
                    Αν δεν κάνατε εσείς τη δήλωση, καλέστε άμεσα στο $phone_contact ή επικοινωνήστε μαζί μας στο <a href='mailto:$eppap_email'>$eppap_email</a>.
                </div>
                
                <div style='margin-top: 30px; padding-top: 15px; border-top: 1px solid #eee; text-align: center; font-size: 12px; color: #777;'>
                    Περισσότερες πληροφορίες: <a href='https://eppap.gr' target='_blank'>eppap.gr</a>
                </div>

            </body>
            </html>
        ";

        $mail->send(); // Αποστολή δεύτερου email

        // ==========================================
        // ΕΜΦΑΝΙΣΗ ΜΗΝΥΜΑΤΟΣ ΕΠΙΤΥΧΙΑΣ
        // ==========================================
        echo "
        <!DOCTYPE html>
        <html lang='el'>
        <head><meta charset='UTF-8'><meta name='viewport' content='width=device-width, initial-scale=1.0'><title>Επιτυχία</title></head>
        <body style='font-family: Helvetica, Arial, sans-serif; text-align: center; padding: 20px; background-color: #F4F7F6;'>
            <div style='background: white; padding: 40px; border-radius: 10px; max-width: 500px; margin: 0 auto; box-shadow: 0 4px 15px rgba(0,0,0,0.1);'>
                <h2 style='color:green;'>Η δήλωση στάλθηκε!</h2>
                <p>Ένα αντίγραφο στάλθηκε στο email σας ($user_email).</p>
                <a href='https://eppap.gr' style='background-color: #0056B3; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Επιστροφή</a>
            </div>
        </body>
        </html>
        ";

    } catch (Exception $e) {
        // Σε περίπτωση λάθους
        echo "
        <div style='color: red; text-align: center; font-family: sans-serif; padding: 50px;'>
            <h2>Παρουσιάστηκε σφάλμα κατά την αποστολή.</h2>
            <p>Παρακαλώ επικοινωνήστε τηλεφωνικά.</p>
            <p>Error Info: {$mail->ErrorInfo}</p>
        </div>
        ";
    }
}
?>